UNIT LogFile;
{ͻ}
{ Routines to open, close & add to the log      Last changed: 20.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-95 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{ Changes made by the German Portal User Team                              }
{                                                                          }
{ By                : Carsten Brandt, Marcus Roeckrath                     }
{ First Modification: 12 August 1998                                       }
{ Last Modification : 29 November 1999                                     }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, NetFile;

CONST
  LogFileOpen : Boolean = False;

VAR
  LogLines : Byte;
  PortalLog : TNetFile;

PROCEDURE WriteLogLine(s: String; i:Byte);
PROCEDURE OpenPortalLog;
PROCEDURE ClosePortalLog(NewLine: Boolean);
PROCEDURE ReWriteLogWindow;
PROCEDURE AddLog(Prefix : Char; CONST Message : String);
PROCEDURE LogWin(Prefix : Char; CONST Message : String);
PROCEDURE WriteActivitySemafore;
{$IFDEF StackCheck}
PROCEDURE LogStackUsage;
{$ENDIF}

IMPLEMENTATION

USES OpCrt, OpDate, OpString,
{$IFDEF StackCheck}
     OpStack,
{$ENDIF}
{$IFNDEF NoOverlay}
     Overlay,
{$ENDIF}
     ScrBlank, FileUtil, PoPTypes, Globals, StrUtil, ApTimer;

  PROCEDURE WriteLogLine(s: String; i: Byte);
  VAR
    t : String;
    j : Byte;
  BEGIN
    IF (LogFileOpen) AND (s<>'') THEN
    BEGIN
      IF Pos(' PORTAL ',s) IN [18,21] THEN  {PORTAL.LOG}
      BEGIN
        IF Cfg.UseYearInLog THEN
          s:=' '+Copy(s,1,2)+Copy(s,13,9)+Copy(s,29,255)
        ELSE
          s:=' '+Copy(s,1,2)+Copy(s,10,9)+Copy(s,26,255);
        ActivityWindow^.wFastText(Copy(s,1,76),i,1);
      END ELSE
      BEGIN
        t:=' '+Copy(s,1,2)+Copy(s,10,9);
        Delete(s, 1, 18);
        j:=Pos(' ',s);
        s:=t+Trim(Copy(s,j+1,255));
{
> 02 Jun 21:39:38 SPRBBS Alan Kwok online at 2400 bps
         1         2         3
123456789012345678901234567890
}
        ActivityWindow^.wFastWrite(Copy(s,1,76),i,1,Cfg.Color[1].FieldColor);
      END;
    END;
  END;

  PROCEDURE OpenPortalLog;
  BEGIN
    IF Cfg.LogFileName<>'' THEN
    BEGIN
      IF NOT PortalLog.Open(ReplaceEnv(Cfg.LogFileName), 1, True) THEN
      BEGIN
        FastWrite('Unable to open log-file',Screenheight,1,7);
        GotoXYAbs(1,ScreenHeight);
        Halt(250);
      END ELSE
      BEGIN
        LogFileOpen:=True;
{$IFDEF StackCheck}
        ReportStackUsage:=False;
{$ENDIF}
      END;
      PortalLog.Seek(PortalLog.FileSize);
    END;
  END;

  PROCEDURE ClosePortalLog(NewLine: Boolean);
  BEGIN
    IF LogFileOpen THEN
    BEGIN
      IF NewLine THEN
      BEGIN
        PortalLog.Seek(PortalLog.FileSize);
        PortalLog.WriteLine('');
      END;
      PortalLog.Close;
      LogFileOpen:=False;
    END;
  END;

  PROCEDURE UpdateActivityWindow(CONST s: String);
  BEGIN
    WITH ActivityWindow^ DO
    BEGIN
      ActivateWrite;
      ScrollVert(1);
      wfasttext(Copy(s,1,76),ScreenHeight-12-Byte(ScreenHeight>LinesForStat)*7,1);
{$IFDEF UseScrollBars}
      ChangeScrollBar(FrRR,1,FileSize(PortalLog));
      DrawSlider(FrRR,FileSize(PortalLog));
{$ENDIF}
      DeactivateWrite;
    END;
  END;

  PROCEDURE ReWriteLogWindow;
  VAR
    i : Byte;
    s : String;
  BEGIN
    IF Not LogFileOpen THEN Exit;
    WITH ActivityWindow^ DO
    BEGIN
      ActivateWrite;
      Clear;
      PortalLog.Seek(CurrentLogView[1]);
      FOR i:=1 TO LogLines DO
        IF (CurrentLogView[i]<>0) THEN
        BEGIN
          PortalLog.ReadLine(s);
          WriteLogLine(s,i);
        END;
      CurrentLogView[LogLines+1]:=PortalLog.FilePos;
      DeactivateWrite;
    END;
  END;

  PROCEDURE AddLog(Prefix: Char; CONST Message: String);
  VAR
    s : string ;
    LogDate,
    LogTime  : String[10];
  BEGIN
    IF Not LogFileOpen THEN Exit;
    IF Cfg.UseYearInLog THEN LogDate:=TodayString('dd nnn yy') ELSE
                             LogDate:=TodayString('dd nnn');
    LogTime:=CurrentTimeString('hh:mm:ss');
    TurnScreen(On);
    IF cfg.logfilename<>'' THEN
    BEGIN
      IF pos(Prefix, '!*+:# ')<=cfg.loglevel+1 THEN
      BEGIN
{$IFNDEF JS}
        s:=Prefix+' '+LogDate+' '+LogTime+' PORTAL '+Copy(Message,1,225);
{$ELSE}
        s:=Prefix+' '+LogDate+' '+LogTime+' POP  '+Copy(Message,1,225);
{$ENDIF}
        IF EndLogView[1]<>CurrentLogView[1] THEN
        BEGIN
          CurrentLogView:=EndLogView;
          ReWriteLogWindow;
        END;
        Move(EndLogView[2],EndLogView[1],(LogLines)*SizeOf(LongInt));
        EndLogView[LogLines]:=PortalLog.FilePos;
        CurrentLogView:=EndLogView;
        PortalLog.Seek(PortalLog.FileSize);
        PortalLog.WriteLine(s);
        CurrentLogView[LogLines+1]:=PortalLog.FileSize;
      END;
    END;
    UpdateActivityWindow(' '+Prefix+' '+LogTime+' '+Message);
  END;

  PROCEDURE LogWin(Prefix: Char; CONST Message: String);
  VAR
    s : string ;
    LogDate,
    LogTime  : String[10];
  BEGIN
    IF Not LogFileOpen THEN Exit;
    IF Cfg.UseYearInLog THEN LogDate:=TodayString('dd nnn yy') ELSE
                             LogDate:=TodayString('dd nnn');
    LogTime:=CurrentTimeString('hh:mm:ss');
    TurnScreen(On);
    IF cfg.logfilename<>'' THEN
    BEGIN
      IF pos(Prefix, '!*+:# ')<=cfg.loglevel+1 THEN
      BEGIN
{$IFNDEF JS}
        s:=Prefix+' '+LogDate+' '+LogTime+' PORTAL '+Copy(Message,1,225);
{$ELSE}
        s:=Prefix+' '+LogDate+' '+LogTime+' POP  '+Copy(Message,1,225);
{$ENDIF}
        IF EndLogView[1]<>CurrentLogView[1] THEN
        BEGIN
          CurrentLogView:=EndLogView;
          ReWriteLogWindow;
        END;
      END;
    END;
    UpdateActivityWindow(' '+Prefix+' '+LogTime+' '+Message);
  END;

  PROCEDURE WriteActivitySemafore;
  VAR F : File OF CHAR;
      C : CHAR;
  BEGIN
    Assign(F, StartPath + MakeTaskFileName(PoPActivityFileName));
    Rewrite(F);
    IF IOResult = 0 THEN BEGIN
      C := 'P';
      Write(F, C);
      Close(F);
    END ELSE AddLog('!', 'Could not write to Portal activity semafore');
    NewTimerSecs(ActivitySemafore, ActivitySemaforeTime);
  END;

{$IFDEF StackCheck}
  PROCEDURE LogStackUsage;
  VAR
    StackUsage : Word;
    HeapUsage : LongInt;
    FreeUsage : Word;
    MemUsage : LongInt;
  BEGIN
    CalcStackUsage(StackUsage, HeapUsage, FreeUsage, MemUsage);
    AddLog('!', 'Stack usage: '+Long2Str(StackUsage)+
                '  Heap usage: '+Long2Str(HeapUsage{$IFNDEF NoOverlay}-OvrGetBuf{$ENDIF})+
                '  Memory usage: '+Long2Str(MemUsage));
  END;
{$ENDIF}

END.
