UNIT FallBack;
{ͻ}
{ FTSC-001 Fallback                             Last changed: 26.06.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                            Birger Kristensen                             }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{ Changes made by the German Portal Team                                   }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 17 August 1999                                       }
{ Last Modification : 17 August 1999                                       }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE FTSC_Sender(WaZoo: Boolean);
FUNCTION  FTSC_Receiver(WaZoo: Boolean): Boolean;

IMPLEMENTATION

USES Dos, OpCrt, OpString, ApTimer,
     PoPTypes, Globals, Util, StrUtil, Modem, WzSend, Com, MailUtil, Protocol,
     NodeList, FileUtil, Crc, MTask, TransVid, LogFile;

  FUNCTION RecvMDM7(VAR FName: S30): Boolean;
  LABEL
    Top, Fubar;
  VAR
    Stat,TempName:S30;
    RetByte:INTEGER;
    i,XChkSum,
    GotEoT,Tries:BYTE;
  BEGIN
    RecvMDM7:=FALSE;
    ComPort^.SetXon(Off);
    Tries:=0;
    GotEoT:=0;
    IF NOT ComPort^.KeyPressed THEN ComPort^.WriteByte(NAK, True);
Top:
    i:=0;
    INC(Tries);
    FILLCHAR(TempName,SizeOf(TempName),0);
    FILLCHAR(FName,SizeOf(FName),0);
    stat:='Que WHAT??';
    WHILE ComPort^.Carrier AND (Tries<8) DO
    BEGIN
      RetByte:=TimedRead(3);
      CASE RetByte OF
        SUB : BEGIN
                IF i<>0 THEN
                  IF Tries<4 THEN GOTO Top ELSE EXIT;
                XChkSum:=SUB;
                i:=1;
                WHILE TempName[i]<>#0 DO
                BEGIN
                  INC(XChkSum,BYTE(TempName[i]));
                  INC(i);
                END;
                ComPort^.PurgeIn;
                ComPort^.WriteByte(XChkSum, True);
                RetByte:=TimedRead(5);
                IF RetByte=ACK THEN
                BEGIN
                  FName:=COPY(TempName,1,8)+'.'+COPY(TempName,9,3);
                  Replace(FName,' ','',0);
                  RecvMDM7:=True;
                  EXIT;
                END;
                GotEoT:=0;
                ComPort^.WriteByte(NAK, True);
                GOTO Top;
              END;
        BYTE('u'),
        ACK  : GOTO Top;
        EOT  : BEGIN
                 ComPort^.WriteByte(ACK, True);
                 IF GotEoT>2 THEN EXIT;
                 INC(GotEoT);
                 GOTO Top;
               END;
        CAN  : BEGIN
                 Stat:='Canceled by remote';
                 GOTO Fubar;
               END;
        ELSE
        BEGIN
          IF RetByte<32 THEN
          BEGIN
            IF GotEoT>2 THEN EXIT ELSE INC(GotEoT);
            ComPort^.PurgeIn;
            ComPort^.WriteByte(NAK, True);
            GOTO Top;
          END;
          IF i>=30 THEN
          BEGIN
            Stat:='FileName too long';
            GOTO Fubar;
          END;
          IF (RetByte>=32) AND (RetByte<=126) THEN TempName[i]:=CHAR(RetByte);
          ComPort^.WriteByte(ACK, True);
        END;
      END;
    END;
Fubar:
    IF Tries>=16 THEN Stat:='FUBAR....';
    AddLog('!',stat);
  END;

  FUNCTION TrySEALink: Integer;
  VAR
    i  : BYTE;
    j  : INTEGER;
    t1 : EventTimer;
    Ch : Byte;
  BEGIN
    ComPort^.PurgeIn;
    FOR i:=0 TO 4 DO
    BEGIN
      ComPort^.WriteByte(BYTE('C'), True);
      NewTimerSecs(t1, 1);
      WHILE NOT TimerExpired(t1) AND ComPort^.Carrier DO
        IF ComPort^.KeyPressed THEN
        BEGIN
          ComPort^.Peek(ch);
          IF (ch=SOH) OR (ch=SYN) THEN
          BEGIN
            TrySEALink:=1;
            EXIT;
          END;
          j:=TimedRead(0);
          IF j=EOT THEN
          BEGIN
            TrySEALink:=2;
            EXIT;
          END ELSE
            IF j=TSync THEN
            BEGIN
              TrySEALink:=0;
              EXIT;
            END;
        END;
    END;
    TrySEALink:=0;
  END;

  FUNCTION FTSC_RecvMail: Boolean;
  VAR
    Done:BOOLEAN;
    FName:PathStr;
    i,GotPacket:BYTE;
    ph : TPktHeader;
    pf : FILE OF TPktHeader;
    Pwd : S10;
  BEGIN
    FTSC_RecvMail:=FALSE;
    AddLog('*','Receiving inbound mail');
    IF NOT ComPort^.Carrier THEN
    BEGIN
      AddLog('!','Other end hung up on us');
      ComPort^.PurgeIn;
      EXIT;
    END;
    AddLog('*','Inbound mail packets');
    FName:=InventPktName;
    ComPort^.PurgeIn;
    ComPort^.WriteByte(BYTE('C'), False);
    ComPort^.WriteByte(1, False);
    ComPort^.WriteByte($FE, True);
    IF ReceiveFile(cfg.inbound[GlobNodeStat],FName,_b)<>0 THEN GotPacket:=1;
    { Check password med videre }
    ASSIGN(pf,cfg.Inbound[GlobNodeStat]+FName); FileMode:=ShareRead+ShareDenyW;
    RESET(pf);
    IF IORESULT=0 THEN
    BEGIN
      Read(pf,ph);
      Close(pf);
      Call.Zone:=ph.origzone;
      Call.Net:=ph.orignet;
      Call.Node:=ph.orignode;
      Call.Point:=0;
      RemapAddress(Call);
      Pwd:=NodelistEntry.Password;
      IF NodesRec.SessionPwd<>'' THEN Pwd:=NodesRec.SessionPwd;
      IF NOT isCaller THEN AddLog(':', 'Remote is: '+NodelistEntry.SystemName+' ('+Address2Str(Call)+')');
      IF Pwd<>'' THEN
      BEGIN
        IF Pwd<>StUpCase(AsciiZ2Str(ph.password,8)) THEN
        BEGIN
          AddLog('!', 'Password error: (local/remote) "'+Pwd+'"/"'+AsciiZ2Str(ph.password,8)+'"');
          IF RenameFile(cfg.Inbound[GlobNodeStat]+FName,cfg.Inbound[GlobNodeStat]+ForceExtension(FName,'BAD')) THEN
            AddLog('!','Mail packet renamed to '+ForceExtension(FName,'BAD'))
          ELSE
            AddLog('!','Mail packet '+FName+' cannot be renamed');
          Exit;
        END ELSE
          AddLog('*', 'Password protected session');
      END ELSE
        IF ph.Password[1]<>#0 THEN
          AddLog('#','Remote has password on you: "'+StUpCase(AsciiZ2Str(ph.password,8))+'"');
    END ELSE
    BEGIN
      AddLog('!','Can''t open received mail packet - aborting!');
      Exit;
    END;
    Done:=FALSE;
    AddLog('*','Inbound file attaches');
    ComPort^.PurgeIn;
    REPEAT
      i:=TrySEALink;
      IF i=0 THEN
      BEGIN
        IF NOT RecvMDM7(FName) THEN Done:=True ELSE
          IF ReceiveFile(Cfg.Inbound[GlobNodeStat],'',TeLink)<>0 THEN
          BEGIN
{            Done:=True;}
            ComPort^.WriteByte(ACK, True);
            INC(FReceived);
          END;
      END ELSE
        IF i=1 THEN
        BEGIN
          IF ReceiveFile(Cfg.Inbound[GlobNodeStat], '', _f)<>0 THEN
          BEGIN
{            Done:=True;}
            ComPort^.WriteByte(ACK, True);
            INC(FReceived);
          END;
        END ELSE
          Done:=True;
    UNTIL Done OR NOT ComPort^.Carrier;
    AddLog('*','End of inbound file attaches');
    ComPort^.PurgeIn;
    FTSC_RecvMail:=True;
  END;

  FUNCTION GetREQStr(VAR Req:STRING): BOOLEAN;
  VAR
    crc,crc1,crc2:WORD;
    i,j:INTEGER;
  BEGIN
    GetREQStr:=FALSE;
    crc:=0;
    i:=0;
    WHILE ComPort^.Carrier DO
    BEGIN
      j:=TimedRead(2);
      IF j<0 THEN EXIT;
      IF j=ETX THEN
      BEGIN
        crc1:=TimedRead(2);
        crc2:=TimedRead(2);
        IF crc<>crc2 SHR 8 OR crc1 THEN
        BEGIN
          AddLog('!','Bad CRC. Trying again');
          Exit;
        END;
        ComPort^.WriteByte(0, True);
        GetREQStr:=True;
        EXIT;
      END ELSE
      BEGIN
        INC(i);
        Req[i]:=CHAR(j);
        crc:=UpdCRC16(j,crc);
      END;
    END;
  END;

  PROCEDURE GenREQName(VAR Req:STRING);
  VAR
    pw,time,FName:S30;
  BEGIN
    FName:=COPY(Req,1,POS(#0,Req)-1);
    Delete(Req,1,LENGTH(FName)+1);
    time:=COPY(Req,1,POS(#0,Req)-1);
    Delete(Req,1,LENGTH(time)+1);
    pw:=COPY(Req,1,POS(#0,Req)-1);
    Req:=FName;
    IF pw<>'' THEN Req:=Req+' !'+pw;
    Req:=Req+' +'+time;
  END;

  PROCEDURE SEA_RecvReq;
  VAR
    t1 : EventTimer;
    NeedToSendACK,Done:BOOLEAN;
    j,NFiles,NFiles1:INTEGER;
    Req:PathStr;
  BEGIN
    NewTimerSecs(t1, 20);
{    IF IsCaller THEN }
    BEGIN
      ComPort^.WriteByte(CAN, True);
      AddLog('*','Refusing inbound file request');
      EXIT;
    END;
    AddLog(':','Inbound file request');
    Done:=FALSE;
    NFiles:=0;
    WHILE ComPort^.Carrier AND NOT Done AND NOT TimerExpired(t1) DO
    BEGIN
      ComPort^.WriteByte(ENQ, True);
      j:=TimedRead(2);
      CASE j OF
        ACK : BEGIN
                NFiles1:=NFiles;
                IF GetREQStr(Req) THEN
                BEGIN
                  GenREQName(Req);
                  NeedToSendACK:=True;
                  SendReqFiles(2,Cfg.Addresses[Cfg.MainAdrNum].Net,Cfg.Addresses[Cfg.MainAdrNum].Node);
                  IF (NFiles<0) OR (NFiles=NFiles1) THEN  { ?? }
                  BEGIN
                    ComPort^.WriteByte(ACK, True);
                    SendFile('','',SEALink);
                  END ELSE
                  BEGIN
                    AddLog(':',Long2Str(NFiles-NFiles1)+' Matching files sent');
                  END;
                END ELSE
                  IF ComPort^.Carrier THEN SendFile('','',SEALink);
                IF NFiles<0 THEN Done:=True;
                NewTimerSecs(t1, 20);
              END;
        ETB,
        ENQ : Done:=True;
        BYTE('C'),
        NAK : BEGIN
                ComPort^.WriteByte(EOT, True);
                ComPort^.PurgeIn;
              END;
      END;
    END;
    AddLog(':','End of inbound file request');
  END;

  PROCEDURE SEA_SendReq;
  VAR
    Done, Done1:BOOLEAN;
    t1 : EventTimer;
    ReqF, HoldName : PathStr;
    sr:SEARCHREC;
    tf:File;
    updtime,pw,name,s,ss:STRING;
    NFiles,i,j:INTEGER;
    Ch : Char;

    PROCEDURE ReqOut(FName,password,UpdTime:STRING);
    VAR
      crc:WORD;
      i:BYTE;
    BEGIN
      AddLog('*','Requesting '+FName);
      ComPort^.WriteByte(ACK, True);
      crc:=0;
      FOR i:=1 TO Length(FName) DO
      BEGIN
        ComPort^.WriteByte(BYTE(FName[i]), False);
        crc:=UpdCRC16(BYTE(FName[i]),crc);
      END;
      ComPort^.WriteByte(0, False);
      crc:=UpdCRC16(0,crc);
      FOR i:=1 TO Length(UpdTime) DO
      BEGIN
        ComPort^.WriteByte(BYTE(UpdTime[i]), False);
        crc:=UpdCRC16(BYTE(UpdTime[i]),crc);
      END;
      ComPort^.WriteByte(0, False);
      crc:=UpdCRC16(0,crc);
      FOR i:=1 TO Length(password) DO
      BEGIN
        ComPort^.WriteByte(BYTE(Password[i]), False);
        crc:=UpdCRC16(BYTE(Password[i]),crc);
      END;
      ComPort^.WriteByte(0, False);
      ComPort^.WriteByte(ETX, False);
      crc:=UpdCRC16(0,crc);
      crc:=UpdCRC16(0,crc);
      ComPort^.WriteByte(LO(crc), False);
      ComPort^.WriteByte(HI(crc), True);
    END;

  BEGIN
    NewTimerSecs(t1, 10);
    HoldName:=HoldFileName(Call,False)+'REQ';
    FindFirst(HoldName,AnyFile,sr);
    IF DOSERROR=0 THEN
    BEGIN
      AddLog(':','Outbound file request');
      ASSIGN(tf,HoldName); FileMode:=ShareRead+ShareDenyW;
      RESET(tf,1);
      WHILE NOT EOF(tf) DO
      BEGIN
        ReadLine(tf,s);
        s:=TrimTrail(s);
        IF COPY(s,1,1)<>';' THEN
        BEGIN
          UpdTime:=' 0';
          pw:='';
          name:='';
          FOR i:=1 TO wordcount(s, [' ']) DO
          BEGIN
            ss:=extractword(i, s, [' ']);
            Ch:=ss[1];
            CASE Ch OF
              '!' : pw:=Copy(ss, 2, 255);
              '+' : updtime:=Copy(ss, 2, 255);
              ELSE IF Ch <> #0 THEN name:=ss;
            END;
          END;
          ReqOut(Name,pw,UpdTime);
          NewTimerSecs(t1, 60);
          Done:=FALSE;
          WHILE ComPort^.Carrier AND NOT TimerExpired(t1) AND NOT Done DO
          BEGIN
            j:=TimedRead(0);
            IF j>=0 THEN
              IF j=ACK THEN
              BEGIN
                NFiles:=0;
                Done1:=FALSE;
                REPEAT
                  i:=TrySEALink;
                  IF i=0 THEN
                  BEGIN
                    IF NOT RecvMDM7(Reqf) THEN
                      Done1:=True
                    ELSE
                      IF ReceiveFile(cfg.inbound[GlobNodeStat],'',TeLink)<>0 THEN Done1:=True ELSE
                        INC(NFiles);
                  END ELSE
                    IF i=1 THEN
                    BEGIN
                      IF ReceiveFile(Cfg.Inbound[GlobNodeStat],'',_f)<>0 THEN Done1:=True ELSE
                        INC(NFiles);
                    END ELSE
                      Done1:=True;
                UNTIL NOT ComPort^.Carrier OR Done1;
                AddLog(':','Received '+Long2Str(NFiles)+' file(s)');
                Done:=True;
                NewTimerSecs(t1, 60);
                WHILE (TimedRead(0)<>ENQ) AND NOT TimerExpired(t1) AND ComPort^.Carrier DO
                  GiveUpTime;
              END
              ELSE
              IF j=ENQ THEN ReqOut(Name,pw,UpdTime) ELSE
              BEGIN
                GiveUpTime;
                IF j<>0 THEN NewTimerSecs(t1, 60);
              END;
          END;
        END;
      END;
      CLOSE(tf);
      DeleteFile(HoldName);
    END ELSE
      AddLog(':','No outbound file request');
    FindClose(sr);
  END;

  FUNCTION FTSC_Receiver(WaZoo: Boolean): Boolean;
  LABEL
    GetOut;
  VAR
    Done  : Boolean;
    t1,t2 : EventTimer;
    i,j   : Integer;
    sr    : SearchRec;
  BEGIN
    FTSC_Receiver:=FALSE;
    GlobNodeStat:=nsKnown;
    IF NOT WaZoo THEN AddLog('*','Receiving mail using FTS-0001 fallback :-(');
    SetUpTransferWindows(false);
    ComPort^.PurgeIn;
    IF NOT FTSC_RecvMail THEN GOTO GetOut;
    FindFirst(HoldFileName(Call,False)+'?UT',AnyFile,sr);
    IF DOSError<>0 THEN FindFirst(HoldFileName(Call,False)+'?LO',AnyFile,sr);
    IF DOSError=0 THEN
    BEGIN
      AddLog('*','Giving mail to '+Address2Str(Call));
      Done:=False;
      NewTimerSecs(t1, 30);
      j:=-1;
      WHILE NOT TimerExpired(t1) AND ComPort^.Carrier AND NOT Done DO
      BEGIN
        ComPort^.WriteByte(TSync, True);
        NewTimerSecs(t2, 3);
        WHILE ComPort^.Carrier AND NOT TimerExpired(t2) AND NOT Done DO
        BEGIN
          i:=TimedRead(0);
          CASE i OF
            BYTE('C'),
            00,
            01   : IF j=BYTE('C') THEN
                   BEGIN
                     Done:=True;
                     SendWazoo(2);
                   END;
            $fe  : IF j=1 THEN
                   BEGIN
                     Done:=True;
                     SendWazoo(2);
                   END;
            $ff  : IF j=0 THEN
                   BEGIN
                     Done:=True;
                     SendWazoo(2);
                   END;
            NAK  : IF j=NAK THEN
                   BEGIN
                     Done:=True;
                     SendWazoo(2);
                   END;
            CAN,
            ENQ,
            SYN  : BEGIN
                     Done:=True;
                     AddLog('*','Remote refused to pick up mail');
                   END;
          END;
          IF i>=0 THEN j:=i;
        END;
      END;
      IF WaZoo THEN GOTO GetOut;
      FindFirst(HoldFileName(Call,False)+'REQ',AnyFile,sr);
      IF DOSError=0 THEN
      BEGIN
        NewTimerSecs(t1, 30);
        Done:=False;
        WHILE NOT TimerExpired(t1) AND ComPort^.Carrier AND NOT Done DO
        BEGIN
          ComPort^.WriteByte(SYN, True);
          NewTimerSecs(t2, 3);
          WHILE NOT TimerExpired(t2) AND ComPort^.Carrier AND NOT Done DO
          BEGIN
            i:=TimedRead(0);
            CASE i OF
              ENQ : BEGIN
                      SEA_SendReq;
                      Done:=True;
                    END;
              CAN : Done:=True;
              BYTE('C'),
              NAK : ComPort^.WriteByte(EOT, True);
              SUB : ComPort^.WriteByte(CAN, True);
            END;
          END;
        END;
      END;
      SEA_RecvReq;
    END ELSE
    BEGIN
      AddLog('*','No mail waiting for '+Address2Str(Call));
    END;
GetOut:
    FindClose(sr);
    FTSC_Receiver:=True;
    RemoveTransferWindows;
    IF NOT WaZoo THEN AddLog('*','End of FTS-0001 session');
  END;

  PROCEDURE FTSC_Sender(WaZoo: Boolean);
  LABEL
    GetOut;
  VAR
    t1 : EventTimer;
    Ch : Byte;
  BEGIN
    IF Not WaZoo THEN
    BEGIN
      AddLog('*','Sending mail using FTS-0001 FallBack :-(');
      AddLog('*', NodeListEntry.SystemName + ' ('+Address2Str(Call)+')');
    END;
    SetupTransferWindows(false);
    SendWaZoo(2);
    NewTimerSecs(t1, 10);
    WHILE NOT TimerExpired(t1) AND ComPort^.Carrier DO
    BEGIN
      IF ComPort^.KeyPressed THEN
      BEGIN
        ComPort^.Peek(Ch);
        CASE Ch OF
          TSync : BEGIN
                    ComPort^.PurgeIn;
                    IF FTSC_RecvMail THEN GOTO GetOut;
                    NewTimerSecs(t1, 10);
                  END;
          SYN   : BEGIN
                    ComPort^.WriteByte(CAN, True);
                    AddLog('!','Refusing inbound file requests');
                    NewTimerSecs(t1, 10);
                  END;
          ENQ   : BEGIN
                    ComPort^.PurgeIn;
                    SEA_SendReq;
                    GOTO GetOut;
                  END;
          NAK,
          67    : BEGIN
                    TimedRead(0);
                    TimedRead(1);
                    TimedRead(1);
                    ComPort^.WriteByte(EOT, True);
                    NewTimerSecs(t1, 10);
                  END;
          SUB   : BEGIN
                    TimedRead(0);
                    ComPort^.WriteByte(CAN, True);
                  END;
          ELSE    BEGIN
                    TimedRead(0);
                    ComPort^.WriteByte(EOT, True);
                  END;
        END;
      END;
    END;
    IF NOT ComPort^.Carrier THEN
    BEGIN
      ComPort^.PurgeIn;
      AddLog('!','Other end hung up on us <HRMPH!!>');
      GOTO GetOut;
    END;
    IF TimerExpired(t1) THEN
    BEGIN
      FTSC_RecvMail;
      AddLog('!','Timeout');
    END;
GetOut:
    IF NOT WaZoo THEN AddLog(':','End of FTS-0001 session (YUCK!)');
    RemoveTransferWindows;
  END;

END.
