UNIT DumbTerm;
{ͻ}
{ Termial program                               Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{ Changes made by the German Portal Team                                   }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 04 September 1998                                    }
{ Last Modification : 13 October 1999                                      }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE TerminalMode;

IMPLEMENTATION

USES Dos, OpCrt, OpWindow, OpDos, OpString, OpEdit, OpMenu, OpEntry, OpCmd,
     OpFrame, OpField, OpDate, OpKey, OpSelect, OpPick, OpRoot, ApTimer,
{$IFDEF OS2}
     VpUtils,
{$ENDIF}
     Globals, PoPTypes, NodeList, Com, Modem, Musica, PingAnsi, TpAvatar,
     OproUtil, Protocol, ZSend, ZReceive, StrUtil, FileUtil, Input, TransVid,
     Keyboard, Display, InterCom, Resource, NetFile, Util, MailUtil, MTask,
     Usage, LCR;

TYPE
  DialDirListe = Object(Picklist)
    f : PNetFile;

    constructor Init(VAR AFile: TNetFile);
    Procedure ItemString(Item: Word; Mode: PkMode; Var IType: PkItemType; var IString: string); Virtual;
  END;

  Constructor DialDirListe.Init(VAR AFile: TNetFile);
  Begin
    f:=@AFile;
    if not INHERITED InitAbstract(34, 5, 65, 18, Cfg.Color[3],
                                  DefWindowOptions or Wbordered,
                                  32, f^.FileSize, PickVertical,
                                  SingleChoice) then
      Fail;
    if Cfg.Screen.ExplodingWin then EnableExplosions(10);
    SetSearchMode(PickStringSearch);
    SetPadSize(1,1);
    Wframe.AddHeader(' Dial List ',heTC);
    AddMoreHeader(' More   ',HeBR,#24,#25,'',7,8,0);
  end;

  procedure Dialdirliste.ItemString(Item : Word; Mode : PkMode; Var IType : PkItemType; Var IString : String);
  var
    DialDir: TDialDir;
  BEGIN
    Istring:='';
    if f^.filesize < Item-1 then Exit;
    f^.GetRec(DialDir,Item-1,NoKeep,Wait);
    IF f^.IoResult=0 THEN IString:=DialDir.Name;
  END;

  PROCEDURE DialDirUpd(ASP: AbstractSelectorPtr); far;
  BEGIN
    WITH cfg.color[2] DO
    BEGIN
      FastWrite(LongIntForm('####',PNetFile(ASP^.wUserData)^.FilePos), 2, 17, HighLightColor);
    END;
  END;

  PROCEDURE TerminalMode;
  VAR
    m           : TPoPMenu;
    DetectStr   : S20;
    InitCmd,
    FileName    : PathStr;
    LogFile     : TBufTextFile;
    LocalEcho,
    LogMode     : Boolean;
    StatusWin,
    TerminalWin : windowptr;
    DialDir     : TDialDir;
    WasOnline   : BOOLEAN;
    GemAttr,
    TermMode,
    SendFileNum : Byte;
    SavePtr     : Pointer;
    SendFileTab : ARRAY[1..50] OF PathStr;
    InKey       : Word;
    InActivity  : EventTimer;

    FUNCTION TermModeStr(CONST i:BYTE):S8;
    BEGIN
      CASE i OF
        0 : TermModeStr:='AUTOMODE';
        1 : TermModeStr:='ANSI-BBS';
        2 : TermModeStr:='AVATAR  ';
       ELSE TermModeStr:='        ';
      END;
    END;

    PROCEDURE DisplayStatusLine;
    VAR
      s : s80 ;
    BEGIN
      s:='Alt-Z for help'+charstr(' ',26)+'';
      IF LocalEcho THEN s:=s+'ECHO' ELSE s:=s+'    ';
      s:=s+''+TermModeStr(termmode)+''+LongIntForm('#####',ComPort^.GetBaudRate)+'-'+ComPort^.GetLinkData;
      IF LogMode THEN s:=s+'Log' ELSE s:=s+'   ';
      IF ComPort^.Carrier THEN s:=s+'On-Line ' ELSE s:=s+'Off-Line';
      StatusWin^.ActivateWrite;
      StatusWin^.wFastWrite(s,1,1,cfg.color[2].BlockColor);
      StatusWin^.DeActivateWrite;
      TextAttr:=GemAttr;
    END;

    PROCEDURE ToggleLogging;
    VAR
      FileName : S67;
    BEGIN
      IF LogMode THEN
      BEGIN
        LogFile.Done;
        LogMode:=False;
      END ELSE
      BEGIN
        FileName:=MakeTaskFileName(PoPDumbTermLogFileName);
        IF InputString(20,8,67,20,2,'Session logging','FileName: ',FileName) THEN
        BEGIN
          LogMode:=LogFile.InitCreate(FileName, SOpenWrite, Max64k(MaxAvail-10240));
        END;
      END;
      DisplayStatusLine;
    END;

    PROCEDURE InitTerminal;
    BEGIN
      StopClock;
      ComPort^.SetFlowControl(2);
      termmode:=0;
      LocalEcho:=False;
      WasOnline:=FALSE;
      LogMode:=False;
      DetectStr:=CharStr(' ',20);
      MyWin(StatusWin,1,ScreenHeight,ScreenWidth,ScreenHeight,0,'',False);
      MyWin(TerminalWin,1,1,ScreenWidth,ScreenHeight-1,0,'',False);
      DisplayStatusLine;
      IF Cfg.DumbTerm.ModemInit<>'' THEN
      BEGIN
        InitCmd:=Cfg.DumbTerm.ModemInit;
        InitModem(Cfg.Modem.BaudRate, Cfg.Modem.PreInit, InitCmd);
      END ELSE
        InitCmd:=Cfg.Modem.Init;
      normalcursor;
      TextAttr:=7;
      GemAttr:=7;
      ClrScr;
      Writeln('OK');
      HelpKey:=AltZ;
      Topic:=60;
      GlobNodeStat:=nsPassword;
      NewTimerSecs(InActivity, 300);
    END;

    PROCEDURE DialNumber;
    VAR
      dial         : windowptr;
      ErrorStatus  : Boolean;
      Name         : S80;
      s            : S40;
      Number       : S20;
      Sec          : LongInt;
      DialAddress  : TFidoAddress;
      RealBaudRate : Word;
      t            : EventTimer;
      f            : TNetFile;
      TempPhone    : S60;

      PROCEDURE DialDirectory;
      LABEL Slut;
      VAR
        key         : WORD;
        esr         : TPoPEntryScreen;

        FUNCTION FindDialEntry(CONST Num: S20) : S20;
        VAR
          n,test : Integer;
          f : TNetFile;
        BEGIN
          ErrorStatus:=TRUE;
          IF f.Open(PoPDumbTermDialDirName, SizeOf(TDialDir), False) THEN
          BEGIN
            Val(Copy(num,1,4),n,test);
            IF test<>0 THEN Exit;
            f.GetRec(DialDir,n-1,NoKeep,Wait);
            IF f.IoResult<>0 THEN
            BEGIN
              f.Close;
              Exit;
            END;
            f.Close;
            ErrorStatus:=FALSE;
            FindDialEntry:=DialDir.Phone;
          END;
        END;

        PROCEDURE InitMenu(VAR m : TPoPMenu);
        BEGIN
          GetMenu(MnuDTDialDir,3,M);
          WITH M DO
          BEGIN
            MenuCommands.AddCommand(ccUser1,1,Word(256 * 73),0);
            MenuCommands.AddCommand(ccUser2,1,Word(256 * 81),0);
          END;
        END;

        PROCEDURE AddDialDirEntry;
        VAR
          i : LongInt;
        BEGIN
          i:=f.FilePos-1;
          FillChar(DialDir,SizeOf(DialDir),#0);
          f.PutRec(DialDir,f.FileSize);
          f.GetRec(DialDir,i,NoKeep,Wait);
        END;

        PROCEDURE FindDirEntry;
        VAR
          Search      : S40;
          Found,
          SearchMore  : Boolean;
          old         : INTEGER;
        BEGIN
          Search:='';
          IF InputString(20,8,40,21,3,'Find entry','Search string : ',Search) AND (Search<>'') THEN
          BEGIN
            Search:=StUpCase(Search);
            old:=f.FilePos-1;
            f.SEEK(0);
            FILLCHAR(DialDir,SizeOf(DialDir),0);
            SearchMore:=TRUE;
            Found:=FALSE;
            WHILE NOT f.EOF AND SearchMore DO
            BEGIN
              f.Read(DialDir,NoKeep,Wait);
              IF POS(search,StUpCase(DialDir.Name))<>0 THEN
              BEGIN
                Found:=TRUE;
                Esr.Select;
                Esr.ResetScreen;
                Esr.Draw;
                SearchMore:=Confirm('Search for more','N',8);
              END;
            END;
            IF NOT Found THEN
            BEGIN
              f.GetRec(DialDir,Old,NoKeep,Wait);
              Esr.ResetScreen;
            END;
          END;
        END;

        PROCEDURE RemoveDialDirEntry;
        VAR
          oldnum,i : LongInt;
        BEGIN
          IF Confirm('Remove current entry','N',8) THEN
          BEGIN
            oldnum:=f.FilePos-1;
            IF oldnum=f.FileSize-1 THEN Dec(oldnum);
            FOR i:=f.FilePos-1 TO f.FileSize-2 DO
            BEGIN
              f.GetRec(DialDir,i+1,NoKeep,Wait);
              f.PutRec(DialDir,i);
            END;
            f.Seek(f.FileSize-1); f.Truncate;
            f.GetRec(DialDir,oldnum,NoKeep,Wait);
            Esr.ResetScreen;
          END;
        END;

        PROCEDURE DialDirList;
        var
          Diallist : DialDirListe;
        BEGIN
          if DialList.Init(f) then
          begin
            DialList.Process;
            DialList.Erase;
            if DialList.GetLastCommand<>ccquit then f.Seek(DialList.GetLastChoice-1);
            DialList.Done;
          end;
        END;

        PROCEDURE SortDialDir;
        VAR
          o,i:LONGINT;
          a,b:TDialDir;
          Flag:BOOLEAN;
          Sort : WindowPtr;
          Working : S40;
        BEGIN
          IF Not Confirm('Sure you want to sort phone list?','N',12) THEN Exit;
          Working := '';
          mywin(Sort,18,12,61,14,2,'Sorting',True);
          o:=f.FILEPOS-1;
          REPEAT
            Flag:=FALSE;
            FOR i:=0 TO f.FileSize-2 DO
            BEGIN
              Sort^.wFastWrite(Working, 1, 2, cfg.color[2].HighLightColor);
              Working := Working[40] + Copy(Working, 1, 39);
              f.GetRec(a,i,NoKeep,Wait); f.Read(b,NoKeep,Wait);
              IF StUpCase(a.name)>StUpCase(b.name) THEN
              BEGIN
                Flag:=TRUE;
                f.PutRec(b,i); f.Write(a);
              END;
            END;
          UNTIL NOT Flag;
          KillWindow(Sort);
          f.GetRec(DialDir,o,NoKeep,Wait);
          Esr.ResetScreen;
        END;

      BEGIN
        IF Number<>'' THEN Number:=FindDialEntry(Number) ELSE
        BEGIN
          ErrorStatus:=True;
          f.Open(StartPath+PoPDumbTermDialDirName, SizeOf(TDialDir), True);
          IF f.FileSize=0 THEN
          BEGIN
            IF Confirm('No entries found. Create one','Y',8) THEN
            BEGIN
              FillChar(DialDir,SizeOf(DialDir),#0);
              f.Write(DialDir);
              f.Seek(0);
            END ELSE
              GOTO Slut;
          END;
          WITH esr DO
          BEGIN
            Esr.Init(3,3,78,20,2,'Dialing Directory');
            AddTextField(  'Entry number  : ',2,2);
            addstringfield('Name          : ',4,2,charstr('X',30),4,20,30,0,DialDir.Name);
            addstringfield('Phone number  : ',6,2,charstr('X',20),6,20,20,0,DialDir.Phone);
            addbytefield(  'Terminal type : ',8,2,'#',8,20,0,0,2,DialDir.termmode);
            esr.wUserData:=LongInt(@f);
            ESR.SetScreenUpdateProc(DialDirUpd);
            Esr.Draw;
            InitMenu(m);
            f.Read(DialDir,NoKeep,Wait);
            REPEAT
              Esr.ResetScreen;
              Esr.Select;
              Esr.Draw;
              m.Select;
              m.Process;
              key:=m.MenuChoice;
              IF m.GetLastCommand IN [ccUser1,ccUser2] THEN
              BEGIN
                CASE m.GetLastCommand OF
                  ccUser1 : IF f.FilePos>1 THEN f.Seek(f.FilePos-2) ELSE f.Seek(f.filesize-1);
                  ccUser2 : IF f.FilePos=f.FileSize THEN f.Seek(0);
                END;
                f.Read(DialDir,NoKeep,Wait);
              END ELSE
              BEGIN
                IF m.GetLastCommand<>ccQuit THEN
                BEGIN
                  CASE key OF
                    1 : IF DialDir.Phone<>'' THEN
                        BEGIN
                          ErrorStatus:=False;
                          Number:=DialDir.Phone;
                          Name:=DialDir.Name;
                        END;
                    2 : BEGIN
                          select;
                          SetNextField(0);
                          process;
                          f.PutRec(DialDir,f.FilePos-1);
                        END;
                    3 : FindDirEntry;
                    4 : BEGIN
                          AddDialDirEntry;
                          f.GetRec(DialDir, f.FileSize-1, NoKeep, Wait);
                        END;
                    5 : BEGIN
                          RemoveDialDirEntry;
                          f.GetRec(DialDir, 0, NoKeep, Wait);
                        END;
                    7 : BEGIN
                          SortDialDir;
                          f.GetRec(DialDir, 0, NoKeep, Wait);
                        END;
                    8 : BEGIN
                          DialDirList;
                          f.Read(DialDir,NoKeep,Wait);
                        END;
                  END;
                END;
              END;
            UNTIL (m.GetLastCommand=ccQuit) OR NOT ErrorStatus;
            Esr.Done;
            m.Done;
          END;
Slut:
          Topic:=60;
          f.Close;
        END;
      END;

    BEGIN
      Number:='';
      IF InputString(20,8,20,20,3,'Dial','Number : ',Number) THEN
      BEGIN
        ErrorStatus:=False;
        IF (POS('/',Number)>0) AND GetAdressFromStr(Number,DialAddress) THEN
        BEGIN
          ErrorStatus:=NOT FindNode(DialAddress,nodelistentry);
          IF NOT ErrorStatus THEN
          BEGIN
            Number:=Nodelistentry.PhoneNumber;
            Name:=nodelistentry.SystemName;
          END;
        END ELSE
        BEGIN
          IF (Number<>'') AND (Upcase(Number[1])='M') THEN
          BEGIN
            Delete(Number,1,1);
            Name:='Manually entered number';
          END ELSE
          BEGIN
            DialDirectory;
            IF NOT ErrorStatus THEN
            BEGIN
              termmode:=DialDir.termmode;
              Name:=DialDir.Name;
            END;
          END;
        END;
        IF NOT ErrorStatus THEN
        BEGIN
          mywin(dial,20,8,60,17,2,'Dialing',True);
          WITH cfg.color[2],dial^ DO
          BEGIN
            wfasttext(' Name     : ',2,1);
            wfasttext(' Calling  : ',3,1);
            wfasttext(' Provider : ',4,1);
            wfasttext(' Zone     : ',5,1);
            wfasttext(' Cost/Min : ',6,1);
            wfasttext(' TimeOut  : ',7,1);
            wfastwrite(Name,2,13,HighLightColor);
          END;
          IF Cfg.Modem.UseLCR THEN TempPhone := LeastCostRouting(Number)
          ELSE BEGIN
            LCR.Costs := MaxLongint;
            LCR.Provider := '?';
            LCR.Zone := '?';
            TempPhone := Number;
          END;
          WITH cfg.color[2],dial^ DO BEGIN
            wfastwrite(TempPhone,3,13,HighLightColor);
            wfastwrite(LCR.Provider,4,13,HighLightColor);
            wfastwrite(LCR.Zone,5,13,HighLightColor);
            IF LCR.Costs < MaxLongint THEN wfastwrite(Long2Str(LCR.Costs),6,13,HighLightColor)
            ELSE wfastwrite('0',6,13,HighLightColor);
          END;
          TranslateModemString(cfg.modem.dial+TempPhone+'|');
          Sec:=cfg.modem.waittime;
          s:='';
          REPEAT
            NewTimerSecs(t, 1);
            dial^.wfastwrite(Long2Str(Sec)+' ',7,13,cfg.color[2].HighLightColor);
            REPEAT
              GiveUpTime ;
            UNTIL ComPort^.KeyPressed OR KeyPressed OR TimerExpired(t);
            Dec(Sec);
            IF ComPort^.KeyPressed THEN s:=ModemReadStr;
          UNTIL (Sec=0) OR KeyPressed OR
                (s='BUSY') OR (Copy(s,1,2)='NO') OR (Copy(s,1,7)='CONNECT');
          KillWindow(Dial);
          WaitForSlowModem;
          IF COPY(s,1,7)='CONNECT' THEN
          BEGIN
            RealBaudRate:=GetRealBaudRate(s);
            UpdateConnectStat(CSUser, CSOut, RealBaudRate, s);
            IF IsLockedBaud(s) THEN
            BEGIN
              ComPort^.SetBaudRate(Cfg.Modem.BaudRate);
              ComPort^.SetCurrentBaud(RealBaudRate);
            END ELSE
            BEGIN
              ComPort^.SetBaudRate(RealBaudRate);
            END;
            WasOnline:=TRUE;
          END;
          DisplayStatusLine;
          TextAttr:=GemAttr;
          WRITELN(#13#10,s);
        END;
      END;
    END;

    PROCEDURE SetUpTransferMenu(CONST Upload : Boolean);
    VAR
      s   : S8;
      i,j : BYTE;
    BEGIN
      IF Upload THEN s:='Upload' ELSE s:='Download';
      j:=6;
      FOR i:=1 TO 5 DO
       WITH Cfg.ExtProt[i] DO
        IF key>=#33 THEN INC(j);
      m.Init(22,6,39,5+j,3,s);
      WITH m DO
      BEGIN
        AddItem('Xmodem',1,1,1);
        AddItem('Ymodem (X-1K)',2,1,2);
        AddItem('Zmodem',3,1,3);
        AddItem('SEALink',4,1,4);
        AddItem('TeLink',5,1,5);
        AddItem('Modem 7',6,1,6);
        j:=6;

        FOR i:=1 TO 5 DO
          WITH Cfg.ExtProt[i] DO
            IF key>=#33 THEN
            BEGIN
              INC(j);
              IF Pos(Key,Name)<>0 THEN AddItem(Name,j,Pos(Key,Name),i+6)
                                  ELSE AddItem(Key+' '+Name,j,1,i+6);
          END;
        ItemsDone;
        Draw;
      END;
    END;

    FUNCTION MakeReplaces(s: STRING): STRING;
    VAR
      i: BYTE;
      f: TBufTextFile;
    BEGIN
      Replace(s,'$port',Long2Str(cfg.Modem.commport),0);
      Replace(s,'$baud',Long2Str(ComPort^.GetBaudRate),0);
      Replace(s,'$filename',filename,0);
      Replace(s,'$inbound',Cfg.Inbound[GlobNodeStat],0);
      IF POS('$filelistname',s)<>0 THEN
      BEGIN
        f.Init('$FILELST.POP', SCreate, 1024);
        FOR i:=1 TO SendFileNum DO
          f.Writeln(SendFileTab[i]);
        f.Done;
        Replace(s,'$filelistname','$FILELST.POP',0);
      END;
      MakeReplaces:=s;
    END;

    PROCEDURE SendFiles;
    VAR
      key     : WORD;
      s       : STRING;
      OldX, OldY,
      i       : BYTE;

      FUNCTION GetFileNames(CONST maxnum: BYTE): BOOLEAN;
      VAR
        Temp:WindowPtr;
        escaped:BOOLEAN;
      BEGIN
        MyWin(Temp,2,2,79,8,3,'Files to send',False);
        SendFileNum:=0;
        FillChar(SendFileTab,SizeOf(SendFileTab),0);
        REPEAT
          INC(SendFileNum);
          Escaped:=NOT InputString(10,10,44,44,2,'Send file','FileName : ',SendFileTab[SendFileNum]);
          IF NOT Escaped AND (SendFileTab[SendFileNum]<>'') THEN
          BEGIN
            Temp^.ScrollVert(1);
            WITH Cfg.Color[3] DO
              Temp^.wFastText(CPad(SendFileTab[SendFileNum],76),5,1);
          END;
        UNTIL (SendFileTab[SendFileNum]='') OR Escaped OR (SendFileNum=MaxNum);
        KillWindow(Temp);
        GetFileNames:=NOT Escaped;
      END;

    BEGIN
      SetUpTransferMenu(True);
      m.Process;
      key:=m.MenuChoice;
      m.Erase;
      IF (m.GetLastCommand<>ccQuit) THEN
      BEGIN
        CASE key OF
          1..2,
          5..6  : SendFileNum:=1;
          3..4  : SendFileNum:=50;
          7..11 : SendFileNum:=10;
        END;
        IF GetFileNames(SendFileNum) THEN
        BEGIN
          IF Key IN [1..6] THEN
            SetupTransferWindows(false)
          ELSE
            SaveWindow(1,1,ScreenWidth,ScreenHeight,True,SavePtr);
          OldX:=WhereX; OldY:=WhereY;
          CASE key OF
            1 : SendFile(SendFileTab[1],'',XModem);
            2 : SendFile(SendFileTab[1],'',YModem);
            3 : BEGIN
                  FOR i:=1 TO SendFileNum DO
                    ZModemSend(SendFileTab[i],'',i,0);
                  ZModemSend('','',-2,0);
                END;
            4 : BEGIN
                  FOR i:=1 TO SendFileNum DO
                    SendFile(SendFileTab[i],'',SeaLink);
                  SendFile('','' ,SEALink);
                END;
            5 : SendFile(SendFileTab[1],'',TeLink);
            6 : SendFile(SendFileTab[1],'',Modem7);
        7..11 : WITH Cfg.ExtProt[Key-6] DO
                BEGIN
                  s:=MakeReplaces(SendCmd);
                  ExecDos(s,True,NoExecDosProc);
                  DeleteFile('$FILELST.POP');
                END;
          END;
          IF Key IN [1..6] THEN
            RemoveTransferWindows
          ELSE
            RestoreWindow(1,1,ScreenWidth,ScreenHeight,True,SavePtr);
          GotoXY(OldX, OldY);
        END;
      END;
      m.Done;
      Topic:=60;
    END;

    PROCEDURE ReceiveFiles(CONST protocolnum: BYTE);
    VAR
      escaped : Boolean;
      Ch      : Char;
      key     : WORD;
      s       : STRING;
      OldX, OldY : Byte;
    BEGIN
      IF Protocolnum=0 THEN
      BEGIN
        SetUpTransferMenu(False);
        m.Process;
        key:=m.MenuChoice;
        m.Erase;
      END ELSE
      BEGIN
        Key:=protocolnum;
        ch:=#0;
      END;
      FileName:=''; escaped:=False;
      IF (m.GetLastCommand<>ccQuit) AND ((Key IN [1..2]) OR ((Key IN [7..11])) AND (Cfg.ExtProt[Key-6].AskDLName)) THEN
      BEGIN
        IF NOT (key IN [3..5]) THEN
        BEGIN
          Escaped:=NOT InputString(3,7,67,55,3,'Receive file','FileName : ',FileName);
        END;
      END;
      IF (m.GetLastCommand<>ccQuit) AND NOT escaped THEN
      BEGIN
        IF Key IN [1..6] THEN
          SetupTransferWindows(False)
        ELSE
          SaveWindow(1,1,ScreenWidth,ScreenHeight,True,SavePtr);
        OldX:=WhereX; OldY:=WhereY;
        CASE key OF
          1 : ReceiveFile(cfg.inbound[GlobNodeStat],FileName,XModem);
          2 : ReceiveFile(cfg.inbound[GlobNodeStat],FileName,YModem);
          3 : ZModemReceive(Cfg.Inbound[GlobNodeStat],False);
          4 : ReceiveFile(cfg.inbound[GlobNodeStat],FileName,SeaLink);
          5 : ReceiveFile(cfg.inbound[GlobNodeStat],FileName,TeLink);
          6 : ReceiveFile(cfg.inbound[GlobNodeStat],FileName,Modem7);
      7..11 : WITH Cfg.ExtProt[Key-6] DO
              BEGIN
                s:=MakeReplaces(RecvCmd);
                ExecDos(s,True,NoExecDosProc);
                DeleteFile('$FILELST.POP');
              END;
        END;
        Pause(100);
        IF Key IN [1..6] THEN
          RemoveTransferWindows
        ELSE
          RestoreWindow(1,1,ScreenWidth,ScreenHeight,True,SavePtr);
        GotoXY(OldX, OldY);
      END;
      Topic:=60;
    END;

    PROCEDURE ScreenImage;
    VAR
      f   : TBufTextFile;
      s   : String;
      x,y : Word;
    BEGIN
      f.InitCreate(MakeTaskFileName(PoPDumbTermImageName), SOpenWrite, 2048);
      FOR y:=0 TO ScreenHeight-1 DO
      BEGIN
        s:='';
        FOR x:=0 TO ScreenWidth-1 DO
{$IFNDEF OS2} {*****}
          s:=s+Char(Mem[videosegment:y * (ScreenWidth*2)+x * 2]);
{$ENDIF}
        f.WriteLn(TrimTrail(s));
      END;
      f.Done;
    END;

    PROCEDURE TerminalEmulation;
    VAR
      key : WORD;
    BEGIN
      GetMenu(MnuDTEmulation,3,m);
      m.Process;
      key:=m.MenuChoice;
      IF m.GetLastCommand<>ccQuit THEN
      BEGIN
        termmode:=key-1;
        DisplayStatusLine;
      END;
      m.Done;
      Topic:=60;
    END;

    PROCEDURE PortSetUp;
    BEGIN
      WITH ComPort^ DO
        IF DataBits=3 THEN
        BEGIN
          DataBits:=2;
          ParityBits:=24;
          StopBits:=4;
        END ELSE
        BEGIN
          DataBits:=3;
          ParityBits:=0;
          StopBits:=0;
        END;
    END;

    PROCEDURE HangUpModem;
    VAR
      Temp:WindowPtr;
    BEGIN
      Tell(Temp, 'Hanging up', 'Dumbterm', 6, 3);
      ModemHangUp;
      IF InitCmd<>'' THEN InitModem(cfg.Modem.BaudRate, cfg.modem.PreInit, InitCmd) ELSE ComPort^.SetDTR(On);
      KillWindow(Temp);
      WasOnline:=FALSE;
      TextAttr:=GemAttr;
      DisplayStatusLine;
    END;

    PROCEDURE TerminalMain;
    VAR
      fc             : Char;
      i,j            : Byte;

      PROCEDURE SendChar(CONST Ch: Byte);
      BEGIN
        ComPort^.WriteByte(Ch, True);
        IF LocalEcho THEN Write(Char(Ch));
      END;

    BEGIN
      ClearAnsiState; ClearAvatarState;
      DisplayStatusLine;
      InKey:=0;
      REPEAT
        IF PopKeyPressed THEN
        BEGIN
          InKey:=PopReadKeyWord;
          CASE Char(Lo(InKey)) OF
      #1..#12,
     #14..#255 : SendChar(Lo(InKey));
           #13 : BEGIN
                   SendChar(13);
                   IF Cfg.DumbTerm.CRSendsLF THEN SendChar(10);
                 END;
            #0 : BEGIN
                   CASE InKey OF
                     AltC : BEGIN
                              TextAttr:=7;
                              CLRSCR;
                            END;
                     AltD : DialNumber;
                     AltE : BEGIN
                              LocalEcho:=NOT LocalEcho;
                              DisplayStatusLine;
                            END;
                     AltH : HangUpModem;
                     AltI : ScreenImage;
                     AltL : ToggleLogging;
                     AltP : PortSetUp;
                     AltR : ReceiveFiles(0);
                     AltS : SendFiles;
                     AltT : TerminalEmulation;
                  F1..F10 : ComPort^.WriteStr(#27'O'+CHAR((Hi(InKey)+21)));
                       Up : ComPort^.WriteStr(#27'[A');
                     Down : ComPort^.WriteStr(#27'[B');
                     Right: ComPort^.WriteStr(#27'[C');
                     Left : ComPort^.WriteStr(#27'[D');
                   END;
                 END;
          END;
          NewTimerSecs(InActivity, 300);
        END ELSE
          InKey:=0;
        IF ComPort^.KeyPressed THEN
        BEGIN
          fc:=Char(ComPort^.ReadByte);
          TextAttr:=GemAttr;

          IF (NOT In_Ansi) AND (NOT In_Avatar) AND (fc=#8) THEN
          BEGIN
            Write(#8);
            IF Cfg.DumbTerm.DestructiveBS THEN Write(' '#8);
          END ELSE
          BEGIN
            CASE TermMode OF
              0 : IF In_Ansi OR NOT (In_Avatar OR (fc=^V) OR (fc=^Y)) THEN
                  BEGIN
                    IF fc=#12 THEN ClrScr ELSE AnsiWrite(fc);
                  END ELSE
                    AvatarWrite(fc);
              1 : IF fc=#12 THEN ClrScr ELSE AnsiWrite(fc);
              2 : AvatarWrite(fc);
            END;
          END;

          GemAttr:=TextAttr;
          IF NOT (In_Avatar OR In_Ansi) THEN
          BEGIN
            IF LogMode THEN LogFile.Write(fc, 1);
            MoveFast(DetectStr[2],DetectStr[1],19);
            DetectStr[20]:=CHAR(fc);
            IF Copy(DetectStr,15,6)='**'#24'B00' THEN
            BEGIN
              SetupTransferWindows(false);
              ZModemReceive(cfg.Inbound[GlobNodeStat],False);
              RemoveTransferWindows;
              NewTimerSecs(InActivity, 300);
              DetectStr:=CharStr(' ',20);
            END;
            j:=0;
            FOR i:=1 TO 5 DO
              WITH Cfg.ExtProt[i] DO
              BEGIN
                IF (AutoStart<>'') AND (AutoStart=Copy(DetectStr,21-Length(AutoStart),20)) THEN
                  Break;
              END;
            IF j<>0 THEN
            BEGIN
              ReceiveFiles(j+6);
              NewTimerSecs(InActivity, 300);
              DetectStr:=CharStr(' ',20);
            END;
          END;
        END ELSE
          IF WasOnline AND NOT ComPort^.Carrier THEN
          BEGIN
            HangUpModem;
            DisplayStatusLine;
            ClearAnsiState; ClearAvatarState;
          END ELSE
            IF (NOT WasOnLine) AND (ComPort^.Carrier) THEN
            BEGIN
              WasOnLine:=True;
              DisplayStatusLine;
            END;
      UNTIL (InKey=AltX) OR
            ((ComPort^.Carrier = TRUE) AND (Cfg.DumbTerm.TimeOutCarrier > 0) AND
             (ElapsedTimeInSecs(InActivity) > Cfg.DumbTerm.TimeOutCarrier)) OR
            ((ComPort^.Carrier = FALSE) AND (Cfg.DumbTerm.TimeOutNoCarrier > 0) AND
             (ElapsedTimeInSecs(InActivity) > Cfg.DumbTerm.TimeOutNoCarrier));
    END;

    PROCEDURE FinishTerminal;
    BEGIN
      IF LogMode THEN LogFile.Done;
      KillWindow(TerminalWin);
      KillWindow(StatusWin);
{     hiddencursor;}
      ComPort^.SetLinkData(8,0,0);
      ComPort^.SetFlowControl(0);
      InitModemForEvent;
      StartClock;
      HelpKey:=F1;
    END;

  BEGIN
    FillChar(Call, SizeOf(Call), 0);
    IF SetInterCom(ICDumbTerm,Call,False) THEN
    BEGIN
      InitTerminal;
      TerminalMain;
      FinishTerminal;
    END;
  END;

END.
