rem.
rem (RUNFD.BAT)
rem.
rem Sample batch file to run FrontDoor with a bulletin board system
rem under it. I use Opus<noTm> (by Wynn Wagner) in this example.
rem.
rem Call up FD
rem.
:loop
FD

rem Trap errorlevels
rem.
rem This assumes that you have defined the errorlevels for 2400, 1200
rem and 300 as 255, 254 and 253. That you have set the crasmail errorlevel
rem to 200 and that you have an external event with the errorlevel 199.
rem 10 is userbrk (built-in) and putting a 1 in there will force it to
rem jump to the 'error' label every time a errorlevel between 1 and 9 occurs.
rem (these are all errors in FrontDoor).
rem.
if errorlevel 255 goto bbs
if errorlevel 254 goto bbs
if errorlevel 253 goto bbs
if errorlevel 200 goto crashin
if errorlevel 199 goto export
if errorlevel  10 goto userbrk
if errorlevel   1 goto fatal

rem This is where we load the 'dobbs' file created by FrontDoor just
rem before it exited to this batch file.
rem.
:bbs
dobbs

rem This is where we import any echomail that may have been received
rem in a crashmail packet. We export here as well to have mail ready
rem at all time since FrontDoor will always scan the messages and
rem files whenever someone calls in for a poll.
rem
rem I use the Conference Mail System (by Bob Hartman on Source Archive).
rem.
:crashin
confmail import -n -f import.cm -a
replylnk -f import.cm
confmail export -t -a
goto loop

rem This is where the external event ends up. We run this every morning
rem before our big event to ensure that all our echomail goes out.
rem
rem I use the Conference Mail System (by Bob Hartman on Source Archive).
rem.
:export
confmail export -t -a
goto loop

rem User pressed (F10) from mailer main menu
rem.
:userbrk
cls
echo.
echo User Break
echo.
goto done

rem Fatal Error reported by FrontDoor
rem We just re-boot here, probably not a good idea, but you can put whatever
rem you'd like here.
rem.
:fatal
boot

rem This is where the user break jump ends up
rem.
:done