/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*           This module was originally written by Bob Hartman              */
/*                                                                          */
/*                       BinkleyTerm VFOSSIL module                         */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern VIOMODEINFO vfos_mode;

#ifdef OS_2
/*PLF Fri  05-05-1989  05:35:11 OS/2 version notes:
 *
 * I have basically made this two completely different versions. A lot
 * of the original real mode version deals with the case when vfossil
 * does not exist. Under OS/2, it is always active.
 *
 */

extern int vfossil_installed;

void 
vfossil_init (void)
{
	PVIOMODEINFO q;

	vfossil_installed = 1;
	q = (PVIOMODEINFO) & vfos_mode;
	vfos_mode.cb = sizeof (VIOMODEINFO);
	VioGetMode (q, 0);
	VioSetAnsi (ANSI_ON, 0);
}

void 
vfossil_cursor (int st)
{
	VIOCURSORINFO cur;

	VioGetCurType (&cur, 0);
	cur.attr = (USHORT) (st ? 0 : -1);
	VioSetCurType (&cur, 0);
}

void 
vfossil_close (void)
{
	vfossil_cursor (1);
	vfossil_installed = 0;
}

void 
fossil_gotoxy (int col, int row)
{
	VioSetCurPos ((USHORT) row, (USHORT) col, 0);
}

int 
fossil_wherex (void)
{
	USHORT row, col = 0;

	VioGetCurPos ((PUSHORT) & row, (PUSHORT) & col, 0);
	return (col);
}

int 
fossil_wherey (void)
{
	USHORT row = 0, col;

	VioGetCurPos ((PUSHORT) & row, (PUSHORT) & col, 0);
	return (row);
}

#ifdef BINKLEY_SOUNDS			/* MB 93-12-18 */

static HMODULE ModHandle = NULL;
static ULONG (*APIENTRY mciSendString) (PSZ pszCommandBuf,
	PSZ pszReturnString,
	USHORT wReturnLength,
	HWND hwndCallBack,
	USHORT usUserParm);

static BOOL mmpm_unavail = FALSE;

void
Make_Sound (char *WaveFile)
{
	APIRET rc;
	PSZ MMPM_ERROR = "!%s Error %d initializing MMPM/2 support";

	char mciStr[100];
	char mciAlias[8];

	if (WaveFile == NULL || mmpm_unavail)
		return;

	if (!ModHandle)
	{
		/* load the MMPM/2 MDM.DLL */

		if (rc = DosLoadModule (mciStr, sizeof (mciStr), "MDM", &ModHandle))
		{
			status_line (MMPM_ERROR, "DosLoadModule", rc);
			mmpm_unavail = TRUE;
			return;
		}

		/* get the mciSendString entry point */

		if (rc = DosQueryProcAddr (ModHandle, 0L, "mciSendString",
			(PFN *) & mciSendString))
		{
			status_line (MMPM_ERROR, "DosQueryProcAddr", rc);
			DosFreeModule (ModHandle);
			mmpm_unavail = TRUE;
			return;
		}
	}

	/* Create an alias for talking to mciSendString */

	sprintf (mciAlias, "bt%02xsnd", TaskNumber);

	/* Open the file */

	sprintf (mciStr, "open %s alias %s wait", WaveFile, mciAlias);
	if (!mciSendString ((PSZ) mciStr, (PSZ) NULL, 0, (HWND) 0, 0))
	{
		/* Play the file */

		sprintf (mciStr, "play %s wait", mciAlias);
		mciSendString ((PSZ) mciStr, (PSZ) NULL, 0, (HWND) 0, 0);

		/* Close the file */

		sprintf (mciStr, "close %s wait", mciAlias);
		mciSendString ((PSZ) mciStr, (PSZ) NULL, 0, (HWND) 0, 0);
	}
}
#endif /* BINKLEY_SOUNDS */
#endif /* OS_2 */

#ifdef _WIN32

extern int vfossil_installed;

void 
vfossil_init (void)
{
#if 0
	PVIOMODEINFO q;

	vfossil_installed = 1;
	q = (PVIOMODEINFO) & vfos_mode;
	vfos_mode.cb = sizeof (VIOMODEINFO);
	VioGetMode (q, 0);
	VioSetAnsi (ANSI_ON, 0);
#endif
}

void 
vfossil_cursor (int st)
{
#if 0
	VIOCURSORINFO cur;

	VioGetCurType (&cur, 0);
	cur.attr = (USHORT) (st ? 0 : -1);
	VioSetCurType (&cur, 0);
#endif
}

void 
vfossil_close (void)
{
	vfossil_cursor (1);
	vfossil_installed = 0;
}

void 
fossil_gotoxy (int col, int row)
{
#if 0
	VioSetCurPos ((USHORT) row, (USHORT) col, 0);
#endif
}

int 
fossil_wherex (void)
{
	return 1;
#if 0
	USHORT row, col;

	VioGetCurPos ((PUSHORT) & row, (PUSHORT) & col, 0);
	return (col);
#endif
}

int 
fossil_wherey (void)
{
	return 1;
#if 0
	USHORT row, col;

	VioGetCurPos ((PUSHORT) & row, (PUSHORT) & col, 0);
	return (row);
#endif
}

USHORT 
VioWrtTTY (PCH pchString, USHORT cbString, USHORT hvio)
{
	return 0;
}

USHORT 
VioWrtCellStr (PCH pchCellString, USHORT cbCellString, USHORT usRow, USHORT usColumn, USHORT hvio)
{
	return 0;
}
#endif

#ifdef DOS16

USHORT far pascal write_screen (PCH, USHORT, USHORT, USHORT, USHORT);
USHORT far pascal write_chars (PCH, USHORT, USHORT, USHORT, USHORT);
USHORT far pascal video_mode (PVIOMODEINFO, USHORT);

void 
vfossil_init ()
{
	char far *q;
	union REGS inregs, outregs;
	struct SREGS s;
	VFOSSIL v;

	v.vfossil_size = sizeof (VFOSSIL);
	q = (char far *) &v;

	vfossil_installed = 0;

	inregs.h.ah = 0x81;
	inregs.h.al = 0;

	segread (&s);
	s.es = FP_SEG (q);
	inregs.x.di = FP_OFF (q);
	(void) int86x (0x14, &inregs, &outregs, &s);

	if (outregs.x.ax == 0x1954)
	{
		/* There is a VFOSSIL out there, so set it up for use */
		inregs.h.al = 1;
		inregs.x.cx = 80;
		q = (char far *) &vfossil_funcs;
		inregs.x.di = FP_OFF (q);
		s.es = FP_SEG (q);
		(void) int86x (0x14, &inregs, &outregs, &s);
		if ((outregs.x.ax == 0x1954) && (outregs.x.bx >= 14))
		{
			/* It is really out there */
			vfossil_installed = 1;
			q = (char far *) &vfos_mode;
			vfos_mode.cb = sizeof (VIOMODEINFO);
			(void) VioGetMode ((PVIOMODEINFO) q, 0);
		}
	}

	if (!vfossil_installed)
	{
		(void) memset ((char *) &vfossil_funcs, 0, sizeof (vfossil_funcs));
		vfossil_funcs.GetMode = video_mode;
		vfossil_funcs.WrtCellStr = write_screen;
		vfossil_funcs.WrtCharStr = write_chars;
	}
}

void 
vfossil_cursor (int st)
{
	CURSOR cur;

	if ((long) vfossil_funcs.GetCurType)
	{
		/* We can make the cursor go away */
		(void) VioGetCurType (&cur, 0);
		cur.cur_attr = st ? 0 : -1;
		(void) VioSetCurType (&cur, 0);
	}
}

void 
vfossil_close ()
{
	union REGS r;

	vfossil_cursor (1);

	r.h.ah = 0x81;
	r.h.al = 2;

	(void) int86 (0x14, &r, &r);

	vfossil_installed = 0;
}

USHORT far pascal 
video_mode (PVIOMODEINFO s, USHORT h)
{
	if (s->cb < 8)
	{
		return (382);
	}

	if (h != 0)
	{
		return (436);
	}

	s->fbType = 1;
	s->color = 1;
	s->col = 80;
	s->row = 23;
	return (0);
}

USHORT far pascal 
write_screen (PCH s, USHORT l,
	USHORT r, USHORT c, USHORT h)
{
	USHORT i;
	int far *p;

	p = (int far *) s;

	/* The following line is just to make -W3 happy */
	i = h;

	gotoxy (c, r);

	l = l / 2;
	for (i = 0; i < l; i++)
	{
		(void) WRITE_BIOS (*p);
		++p;
	}

	return (0);
}

USHORT far pascal 
write_chars (PCH s, USHORT l,
	USHORT r, USHORT c, USHORT h)
{
	USHORT i;

	/* The following line is just to make -W3 happy */
	i = h;

	gotoxy (c, r);

	for (i = 0; i < l; i++)
	{
		(void) WRITE_BIOS (*s);
		++s;
	}

	return (0);
}
#endif							/*defined DOS16 */
