#include <stdio.h>
#include <msgapi.h>

int dump_it (char *folder)
{
    struct _minf  minf;
    MSG  *ahandle;
    MSGH *mhandle;
    XMSG  xmsg;
    dword msgnum;

    minf.req_version = 0;
    minf.def_zone = 0;
    MsgOpenApi(&minf);

    MsgCloseApi();
    if ((ahandle = MsgOpenArea((unsigned char *)folder, MSGAREA_NORMAL, MSGTYPE_SQUISH))==NULL)
    {
        fprintf (stderr, "Could not open squish area %s.\n", folder);
        return 8;
    }

    printf ("Area: %s\n", folder);
    printf (" Msg# %-20.20s  %-20.20s  %-20.20s\n",
            "FTSC-Date",
            "Squish Written Date",
            "Squish Arrived Date");

    for (msgnum=1; msgnum <= MsgNumMsg(ahandle); ++msgnum)
    {
        mhandle=MsgOpenMsg(ahandle, MOPEN_READ, msgnum);
        if (mhandle == NULL)
        {
            fprintf (stderr, "Squish area %s is corrupt.\n", folder);
            MsgCloseArea(ahandle);
            return 8;
        }
        if (MsgReadMsg(mhandle, &xmsg, 0L, 0L, NULL, 0L, NULL) == -1)
        {

            fprintf (stderr, "Squish area %s is corrupt.\n", folder);
            MsgCloseMsg(mhandle);
            MsgCloseArea(ahandle);
            return 8;
        }

        printf ("%5ld %-20.20s  %02d.%02d.%04d, %02d:%02d:%02d  %02d.%02d.%04d, %02d:%02d:%02d\n",
                MsgMsgnToUid(ahandle, msgnum),
                xmsg.__ftsc_date,
                xmsg.date_written.date.da,
                xmsg.date_written.date.mo,
                xmsg.date_written.date.yr+1980,
                xmsg.date_written.time.hh,
                xmsg.date_written.time.mm,
                xmsg.date_written.time.ss * 2,
                xmsg.date_arrived.date.da,
                xmsg.date_arrived.date.mo,
                xmsg.date_arrived.date.yr+1980,
                xmsg.date_arrived.time.hh,
                xmsg.date_arrived.time.mm,
                xmsg.date_arrived.time.ss * 2);

        MsgCloseMsg(mhandle);
    }

    MsgCloseArea(ahandle);
    return 0;
}


int main(int argc, char **argv)
{
    if (argc != 2)
    {
        fprintf (stderr, "Usage:\n"
                         "          sqdate <filename>\n\n"
                         " Where <filename> is the basename of a squish folder.\n");
        return 4;
    }

    dump_it(argv[1]);

    return 0;
}
