#include <stdio.h>
#include <time.h>

static struct tm *char_to_tm(unsigned char arr[])
{
    static struct tm tms;
    unsigned long x;
    x = ( ((unsigned long) arr[0]) << 16) |
        ( ((unsigned long) arr[1]) << 24) |
           (unsigned long) arr[2]         |
        ( ((unsigned long) arr[3]) << 8);

    tms.tm_sec = (x & 0x1f) * 2;
    x >>= 5;
    tms.tm_min = x & 0x3f;
    x >>= 6;
    tms.tm_hour = x & 0x1f;
    x >>= 5;
    tms.tm_mday = x & 0x1f;
    x >>= 5;
    tms.tm_mon = (x & 0x0f) - 1;
    x >>= 4;
    tms.tm_year = (x & 0x7f) + 80;
    tms.tm_isdst = -1;
    return &tms;
}

int main(int argc, char **argv)
{
    unsigned char buffer[0xBE];
    FILE *f;
    time_t t;
    struct tm *tm;

    if (argc != 2)
    {
        fprintf (stderr, "Usage:\n"
                         "          msgdate <filename>\n\n"
                         " Where <filename> is the name of a file in Fido *.MSG format.\n");
        return 4;
    }

    printf ("File: %s\n", argv[1]);
    printf ("      %-20.20s  %-20.20s  %-20.20s\n",
            "FTSC-Date",
            "Opus Written Date",
            "Opus Arrived Date");


    if ((f = fopen(argv[1], "rb")) == NULL)
    {
        fprintf (stderr, "Could not open file %s.\n", argv[1]);
        return 8;
    }

    if (fread(buffer,1,0xBE,f) != 0xBE)
    {
        fprintf (stderr, "Could not read file %s.\n", argv[1]);
        return 8;
    }

    printf ("      %-20.20s", buffer+0x90);

    tm = char_to_tm(buffer+0xB0);

    printf ("  %02d.%02d.%04d, %02d:%02d:%02d  ",
       tm->tm_mday, tm->tm_mon+1, tm->tm_year+1900,
       tm->tm_hour, tm->tm_min, tm->tm_sec);

    tm = char_to_tm(buffer+0xB4);

    printf ("%02d.%02d.%04d, %02d:%02d:%02d\n",
       tm->tm_mday, tm->tm_mon+1, tm->tm_year+1900,
       tm->tm_hour, tm->tm_min, tm->tm_sec);

    fclose(f);
    return 0;
}


