#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

char months[12][4] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", 
                      "Jul", "Aug", "Sep", "Oct", "Nov", "Dez"};

#define getulong(cptr) \
  (((unsigned long)(((unsigned char *)(cptr))[0]))       + \
   ((unsigned long)(((unsigned char *)(cptr))[1]) << 8)  + \
   ((unsigned long)(((unsigned char *)(cptr))[2]) << 16) + \
   ((unsigned long)(((unsigned char *)(cptr))[3]) << 24))

void printdate(unsigned long timestamp)
{
    time_t ts = (time_t) timestamp;

    if (timestamp)
    {
        struct tm *ptm = gmtime(&ts);

        printf ("%02d %-3s %04d  %02d:%02d:%02d   ",
                ptm->tm_mday, months[ptm->tm_mon % 12],
                ptm->tm_year + 1900, ptm->tm_hour, ptm->tm_min, ptm->tm_sec);
    }
    else
        printf ("%23s ","");
}

int main(int argc, char **argv)
{
    unsigned char buffer[19*4];
    FILE *f;
    char *filename;
    size_t br;
    int rv;

                                /* check command line arguments */

    if (argc != 2)
    {
        fprintf (stderr, "Usage:\n"
                         "          jamdate <filename>\n\n"
                         "Where <filename> is the base file name (without .J?? extension) of the area\n");

        return 4;
    }

                                /* construct header file name */

    filename = malloc(strlen(argv[1])+5);
    if (filename == NULL)
    {
        fprintf (stderr, "Out of memory.\n");
        return 8;
    }
    strcpy(filename, argv[1]);
    strcat(filename, ".jhr");

                                /* open the .jhr file */

    if ((f = fopen(filename, "rb")) == NULL)
    {
        fprintf (stderr, "Could not open file %s.\n", argv[1]);
        return 8;
    }

                                /* some integrity checks */

    if (fread(buffer,1,4,f) != 4)
    {
        fprintf (stderr, "Could not read file %s.\n", filename);
        return 8;
    }
    if (buffer[0] != 'J' || buffer[1] != 'A' ||
        buffer[2] != 'M' || buffer[3]!='\0')
    {
        fprintf (stderr, "%s does not seem to be a JAM header file.\n",
                 filename);
        return 8;
    }

                                /* paint a header on screen */
    
    printf ("File: %s\n", filename);
    printf (" Msg# %-20.20s    %-20.20s    %-20.20s\n",
            "Date Written",
            "Date Received",
            "Date Processed");

                                /* seek to the first message */

    if (fseek(f, 1024, SEEK_SET))
    {
        fprintf (stderr, "Seek error on file %s.\n", filename);
    }


    rv = 0;
    do
    {
                                /* read the message header */

        br = (size_t)fread(buffer, 1, 19*4, f);
        if (br == 19 * 4)       /* could be a valid message header */
        {
                                /* check if it actually is a msg hdr */

            if (buffer[0] != 'J' || buffer[1] != 'A' ||
                buffer[2] != 'M' || buffer[3]!='\0')
                goto corrupt;

                                /* test if message is deleted */

            if ((getulong(buffer+52) & 0x80000000UL) == 0)
            {

                /* print the dates of this message */
                
                printf ("%5ld ",getulong(buffer+48));
                printdate(getulong(buffer+36));
                printdate(getulong(buffer+40));
                printdate(getulong(buffer+44));
                printf ("\n");
            }

                                /* seek over any subfield data */

            if (fseek(f, getulong(buffer+8), SEEK_CUR))
            {
                fprintf (stderr, "File seek error on file %s.\n",
                         filename);
                rv = 8;
                break;
            }
        }                
        else if (br != 0)       /* corrupt message header */
        {
        corrupt:
            rv = 8;
            fprintf (stderr, "%s contains a corrupt message header.\n",
                     filename);
        }
    } while (br == 19*4 && rv == 0);

    return rv;
}


