/*
 * MultiMail offline mail reader
 * Packet base class

 Copyright (c) 1999 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef PKT_H
#define PKT_H

#include "mmail.h"

class pktbase : public specific_driver
{
 protected:
	mmail *mm;
	struct bodytype **body;
	file_header **bulletins;

	char packetBaseName[9], *bodyString;
	int maxConf, ID, currentArea, currentLetter;
	unsigned hasOffConfig;

	void checkLatin(letter_header &);
	void listBulletins(const char [][13], int);
 public:
	int getNoOfAreas();
	void selectArea(int);
	virtual int getNoOfLetters() = 0;
	void resetLetters();
	file_header *getFileList();
	file_header **getBulletins();
	const char *getBaseName();
};

class pktreply : public reply_driver
{
 protected:
	class upl_base
	{
	 public:
		char fname[50];
		upl_base *nextRecord;
		long msglen;
	} *uplListHead, *uplListCurrent;

	mmail *mm;
	pktbase *baseClass;
	file_list *upWorkList;
	const char *extent, *extent2;

	char replyPacketName[13], *replyText;
	int currentLetter, noOfLetters;
	bool replyExists;

	void cleanup();
	void uncompress();
	virtual void getReplies(FILE *) = 0;
	void readRep();
	void repFileName();
	void addUpl(upl_base *);
	virtual void addRep1(FILE *, upl_base *) = 0;
	virtual void addHeader(FILE *) = 0;
	virtual const char *repTemplate(const char *, bool) = 0;
 public:
	bool checkForReplies();
	void init();
	int getNoOfAreas();
	void selectArea(int);
	int getNoOfLetters();
	void resetLetters();
	const char *getBody(letter_header &);
	file_header *getFileList();
	file_header **getBulletins();
	void killLetter(int);
	area_header *refreshArea();
	bool makeReply();
	void deleteReplies();
};

#endif
